<?php

require_once "conexion.php";

class ModeloCobros{

	/*=============================================
	CREAR CONTRATOS
	=============================================*/

	static public function mdlIngresarContratos($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(codigo, idusuario, idpersona, numromeses, idtipo_servicios) VALUES (:codigo, :idusuario, :idpersona, :numromeses, :idtipo_servicios)");

		
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":numromeses", $datos["numromeses"], PDO::PARAM_STR);
		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);	


		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}


	static public function mdlIngresarCobros($tabla, $datos){

		$con = Conexion::conectar();

		$stmt = $con->prepare("INSERT INTO $tabla(idpersona, idusuario, idservicios, codigo, codigoA, codigoR, mpago, notitas, banco, subtotal, total, fecha_cobro, recargo, tipo) VALUES (:idpersona,:idusuario, :idservicios, :codigo, :codigoA, :codigoR, :mpago, :notitas, :banco, :subtotal, :total, :fecha_cobro, :recargo, :tipo)");
		
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idservicios", $datos["idservicios"], PDO::PARAM_INT);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":codigoA", $datos["codigoA"], PDO::PARAM_INT);
		$stmt->bindParam(":codigoR", $datos["codigoR"], PDO::PARAM_STR);
		$stmt->bindParam(":mpago", $datos["mpago"], PDO::PARAM_STR);
		$stmt->bindParam(":notitas", $datos["notitas"], PDO::PARAM_STR);
		$stmt->bindParam(":banco", $datos["banco"], PDO::PARAM_STR);
		$stmt->bindParam(":subtotal", $datos["subtotal"], PDO::PARAM_INT);
		$stmt->bindParam(":total", $datos["total"], PDO::PARAM_INT);
		$stmt->bindParam(":fecha_cobro", $datos["fecha_cobro"], PDO::PARAM_INT);
		$stmt->bindParam(":recargo", $datos["recargo"], PDO::PARAM_INT);
		$stmt->bindParam(":tipo", $datos["tipo"], PDO::PARAM_STR);	

		


		if($stmt->execute()){
			$idd = $con->lastInsertId();

			return $idd;

		}else{

			return "error";
		
		}

		$stmt = null;

	}
	// FUNCION QUE GUARDA EL DETALLE DE LA CAJA
	static public function mdlIngresarDetalleCaja($tabla, $datos){
		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(idCaja, fechaRegistro, tipoCaja, concepto, numeroDocumento, importeCaja, tipoPago, generadoPor, estadoCaja) VALUES (:idCaja,:fechaRegistro,:tipoCaja,:concepto,:numeroDocumento,:importeCaja,:tipoPago,:generadoPor,:estadoCaja)");
		

		$stmt->bindParam(":idCaja", $datos["idCaja"], PDO::PARAM_INT);
		$stmt->bindParam(":fechaRegistro", $datos["fechacobro"], PDO::PARAM_STR);
		$stmt->bindParam(":tipoCaja", $datos["tipoCaja"], PDO::PARAM_STR);
		$stmt->bindParam(":concepto", $datos["concepto"], PDO::PARAM_STR);
		$stmt->bindParam(":numeroDocumento", $datos["numeroDocumento"], PDO::PARAM_INT);
		$stmt->bindParam(":importeCaja", $datos["total"], PDO::PARAM_INT);
		$stmt->bindParam(":tipoPago", $datos["tipoPago"], PDO::PARAM_STR);
		$stmt->bindParam(":generadoPor", $datos["idusuario"], PDO::PARAM_STR);
		$stmt->bindParam(":estadoCaja", $datos["estadoCaja"], PDO::PARAM_STR);	
		if($stmt->execute()){
			return "ok";
		}else{

			return "error";
		
		}

		$stmt = null;
	}

	static public function mdlIngresarDetalleCobros($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("INSERT INTO $tabla(idcobros, idcronograma_pago) VALUES (:idcobros,:idcronograma_pago)");
		
		$stmt->bindParam(":idcobros", $datos["idcobro"], PDO::PARAM_INT);
		$stmt->bindParam(":idcronograma_pago", $datos["idcronograma_pago"], PDO::PARAM_INT);	


		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	static public function mdlMostrarCobrosReporte($tabla, $item, $valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		


		$stmt = null;

	}


	static public function mdlActualizarCronograma($tabla, $idcronograma_pago){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 1 WHERE idcronograma_pago = :idcronograma_pago");	

		$stmt->bindParam(":idcronograma_pago", $idcronograma_pago, PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

		static public function mdlActualizarCronogramaVencidos($tabla, $idcronograma_pago){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 2 WHERE idcronograma_pago = :idcronograma_pago");

		$stmt->bindParam(":idcronograma_pago", $idcronograma_pago, PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	// consultar si un cronograma de pago ya vencio
	static public function mdlFechaVencido(){

			$stmt = Conexion::conectar()->prepare("SELECT idcronograma_pago, fechas_pagos from cronograma_pago WHERE estado = 0");

			$stmt -> execute();

			return $stmt -> fetchAll();

		

		$stmt = null;
	}


	static public function mdlEliminarCobro($tabla, $idcronograma_pago){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 0 WHERE idcronograma_pago = :idcronograma_pago");

		$stmt->bindParam(":idcronograma_pago", $idcronograma_pago, PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	static public function mdlActualizarServicio($tabla, $idservicios){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 0 WHERE idservicios = :idservicios");

		$stmt->bindParam(":idservicios", $idservicios, PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	static public function mdlActualizarServicioR($tabla, $idservicios){
		date_default_timezone_set("America/Lima");
		setlocale(LC_ALL, 'spanish');
		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 0, fecha_suspension = null, fecha_reconexion = :fecha_reconexion WHERE idservicios = :idservicios");

		$date = date("Y-m-d H:i:s");
		$stmt->bindParam(":idservicios", $idservicios, PDO::PARAM_INT);
		$stmt->bindParam(":fecha_reconexion", $date, PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	static public function mdlActualizarCrono($tabla, $idservicios){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET estado = 0 WHERE idcronograma_pago = :idservicios");

		$stmt->bindParam(":idservicios", $idservicios, PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	static public function mdlFinalizarServicio($idservicios){
		date_default_timezone_set("America/Lima");
		setlocale(LC_ALL, 'spanish');
		$stmt = Conexion::conectar()->prepare("UPDATE servicios SET estado = 2,fecha_suspension = null, fecha_reconexion = null, fecha_finalizacion = :fecha_finalizacion WHERE idservicios = :idservicios");

		$date = date("Y-m-d H:i:s");
		$stmt->bindParam(":idservicios", $idservicios, PDO::PARAM_INT);
		$stmt->bindParam(":fecha_finalizacion", $date, PDO::PARAM_STR);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}


	static public function mdlEditarCobro($tabla, $item, $valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		

		$stmt = null;

	}	


	static public function mdlUltimoPago($tabla, $valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE estado = 1 AND idservicios = :item ORDER BY idcronograma_pago DESC");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_INT);

			$stmt -> execute();

			return $stmt -> fetch();

		

		$stmt = null;

	}


	static public function mdlMesesFlatantes( $valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT * FROM contar_meses WHERE idservicios = :valor");

			$stmt -> bindParam(":valor", $valor, PDO::PARAM_INT);
			$stmt -> execute();

			return $stmt -> fetch();

		

		$stmt = null;

	}	


	static public function mdlObtenerCobrosFaltantes($valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT COUNT(estado) AS conteo FROM cronograma_pago WHERE estado in (0,2) AND idservicios = :item");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		

		$stmt = null;

	}	

	static public function mdlObtenercronograma($tabla,$valor){

		
			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE idcobros = :item");

			$stmt -> bindParam(":item", $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetchAll();

		

		$stmt = null;

	}	


	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function mdlMostrarCobros($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY idcobros DESC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			$resultado = $stmt -> fetch(PDO::FETCH_ASSOC);
			return $resultado ? $resultado : false;

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla ORDER BY idcobros DESC");

			if($stmt -> execute()){
				$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
				
				// Asegurar que siempre devolvemos un array
				if($resultado === false){
					return array();
				}
				
				return is_array($resultado) ? $resultado : array();
			} else {
				// Si hay error en la ejecución, devolver array vacío
				return array();
			}

		}


		$stmt = null;

	}

	/*=============================================
	MOSTRAR COBROS OPTIMIZADO (con JOIN para vista de lista)
	=============================================*/

	static public function mdlMostrarCobrosOptimizado($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT c.*, p.nombres, p.documento, p.direccion 
				FROM $tabla c 
				LEFT JOIN persona p ON c.idpersona = p.idpersona 
				WHERE c.$item = :$item 
				ORDER BY c.idcobros DESC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			$resultado = $stmt -> fetch(PDO::FETCH_ASSOC);
			return $resultado ? $resultado : false;

		}else{

			// Consulta optimizada con JOIN para traer datos de persona en una sola query
			$stmt = Conexion::conectar()->prepare("SELECT c.*, p.nombres, p.documento, p.direccion 
				FROM $tabla c 
				LEFT JOIN persona p ON c.idpersona = p.idpersona 
				ORDER BY c.idcobros DESC");

			if($stmt -> execute()){
				$resultado = $stmt -> fetchAll(PDO::FETCH_ASSOC);
				
				// Asegurar que siempre devolvemos un array
				if($resultado === false){
					return array();
				}
				
				return is_array($resultado) ? $resultado : array();
			} else {
				// Si hay error en la ejecución, devolver array vacío
				return array();
			}

		}

		$stmt = null;

	}

	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function mdlMostrarCobrosSerieA($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item ORDER BY idcobros ASC");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_STR);

			$stmt -> execute();

			return $stmt -> fetch();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla  ORDER BY idcobros ASC");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}	


	static public function mdlMostrarCronograma($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item and estado IN (0,2)");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_INT);

			$stmt -> execute();

			//echo $tabla +" "+ $item +" "+ $valor;

			return $stmt -> fetchAll();

		}else{

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla");

			$stmt -> execute();

			return $stmt -> fetchAll();

		}


		$stmt = null;

	}	



	static public function mdlMostrarCronogramaPago($tabla, $item, $valor){

		if($item != null){

			$stmt = Conexion::conectar()->prepare("SELECT * FROM $tabla WHERE $item = :$item");

			$stmt -> bindParam(":".$item, $valor, PDO::PARAM_INT);

			$stmt -> execute();

			//echo $tabla +" "+ $item +" "+ $valor;

			return $stmt -> fetch();

		}


		$stmt = null;

	}	


	static public function mdlEliminarCobros($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE idcobros = :idcobros");

		$stmt -> bindParam(":idcobros", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}




	
	
	

	/*=============================================
	EDITAR CONTRATOS
	=============================================*/

	static public function mdlEditarContratos($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET idservicios = :idservicios, codigo = :codigo, idusuario = :idusuario, idpersona= :idpersona, numromeses= :numromeses, idtipo_servicios= :idtipo_servicios WHERE idservicios = :idservicios");

		$stmt->bindParam(":idservicios", $datos["idservicios"], PDO::PARAM_INT);
		$stmt->bindParam(":codigo", $datos["codigo"], PDO::PARAM_INT);
		$stmt->bindParam(":idusuario", $datos["idusuario"], PDO::PARAM_INT);
		$stmt->bindParam(":idpersona", $datos["idpersona"], PDO::PARAM_INT);
		$stmt->bindParam(":numromeses", $datos["numromeses"], PDO::PARAM_STR);
		$stmt->bindParam(":idtipo_servicios", $datos["idtipo_servicios"], PDO::PARAM_INT);



		if($stmt->execute()){

			return "ok";

		}else{

			return "error";
		
		}

		$stmt = null;

	}

	/*=============================================
	ELIMINAR CONTRATOS OJO
	=============================================*/

	static public function mdlEliminarContrato($tabla, $datos){

		$stmt = Conexion::conectar()->prepare("DELETE FROM $tabla WHERE idpersona = :idpersona");

		$stmt -> bindParam(":idpersona", $datos, PDO::PARAM_INT);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}


	/*=============================================
	ACTUALIZAR CONTRARO
	=============================================*/

	static public function mdlActualizarContrato($tabla, $item1, $valor1, $valor){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE id = :id");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":id", $valor, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}


	/*=============================================
	ELIMINAR COBROS O DESACTIVAR
	=============================================*/

	static public function mdlDesactivarCobros($tabla, $item1, $valor1, $item2, $valor2){

		$stmt = Conexion::conectar()->prepare("UPDATE $tabla SET $item1 = :$item1 WHERE $item2 = :$item2");

		$stmt -> bindParam(":".$item1, $valor1, PDO::PARAM_STR);
		$stmt -> bindParam(":".$item2, $valor2, PDO::PARAM_STR);

		if($stmt -> execute()){

			return "ok";
		
		}else{

			return "error";	

		}


		$stmt = null;

	}

	
	

}